
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1136.C - Message 1136 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1136 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1136.C_v  $
//   
//      Rev 1.17   07 Jan 2000 15:08:28   phungh
//   Labmon60 : Improve the vEEP transfer by
//   detecting when a bad vEEP copy was sent
//   to the Rx.
//   
//      Rev 1.16   08 Dec 1999 15:51:14   phungh
//   Modify for vEEPROM test capability
//   
//      Rev 1.15   09 Nov 1998 10:47:52   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:42:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:28   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:06:52   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:58   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

extern void wait(float);  
extern void clear_message_line(void);
extern void clear_command_line(void);

extern tBOOL   vEEPROMStatus;                  // vEEPROM checksum status
extern tUSHORT vEEPBlockBitMap;
extern tSHORT  vEEPResend; 
extern tBOOL   vEEPTransferInProgress;
extern tBOOL   vEEPRequired; 
extern tBOOL   vEEPAvailable; 

static tSHORT  Count1136=0;

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1136 message from the ZMsgBuf.
//
void Dec1136(tMSGBUF *ZMsgBuf, tMSG1136 *Msg)
{
   GetBit(&DeviceNotPresent        , ZMsgBuf, 9, 0);  // 1=not present 
//   GetBit(&vEEPROMStatus		   , ZMsgBuf, 9, 1);  // 1=bad,0=good  
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1136 message in the ZMsgBuf. 
//
void Bld1136(tMSGBUF *ZMsgBuf, tMSG1136 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1136                          , ZMsgBuf, 2);     // message number
   PutShort  (12                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);     // header check sum
                                                  
 //PutShort  (CheckSum(ZMsgBuf, 6, 12)      , ZMsgBuf,18);     // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1136 message from the ZMsgBuf.
//
void Show1136(tMSG1136 *Msg)
{
   char         Buf[100] = ""; 

   
   // perform special processing for output
   
   if(DeviceNotPresent && (Msg->Status == 0)){
   
      sprintf(Buf,"MSG 1136: EEPROM NOT PRESENT");
   }
   else{
      sprintf(Buf,"MSG 1136: ALM FAIL:%08lX FAIL:%08lX "
                  "ALM STATUS:%08lX STATUS:%08lX",
                  Msg->AlmFailure, Msg->Failure, 
                  Msg->AlmStatus, Msg->Status);    
   }
    
   // output the data items                                                                                                  
   clear_message_line();
   ShowText(Buf,CMDR   ,CMDC   ); 
   sprintf(Buf,"1136 Device: %x",Msg->Device);
   ShowText(Buf,40,25);
//   wait(.5f);     
   
   Count1136++;

   if(Count1136 == 4)
   {
   		Count1136 = 0;    

   		// Invalid vEEPROM, but only set up to send in the vEEP when 
   		// vEEPBlockBitMap != 0xffff which is the condition at start-up,
   		// reset or something wrong with the communication. For the case
   		// of bad communication, only one more attempt is carried out and
   		// most likely will not succeed.
   		if( ((Msg->Device & 0x0002) != 0) && (vEEPBlockBitMap != 0xffff) ) 
   		{
	  			vEEPRequired		  = TRUE;
      			vEEPBlockBitMap	  = 0;
      			vEEPResend		  = 0; 
//      			vEEPAvailable		  = TRUE;
	  			vEEPTransferInProgress = FALSE;
   		}
   		// Invalid vEEPROM and if the communication did succeed (vEEPBlockBitMap
   		// == 0xffff), chances are the vEEPROM copy is bad.
		else if( ((Msg->Device & 0x0002) != 0) && (vEEPBlockBitMap == 0xffff) ) 
		{
			if(vEEPAvailable)
			{  
			   sprintf(Buf,"vEEPROM MAY BE BAD !!!");
   			   clear_command_line();
   			   ShowText(Buf,CMDR-1,CMDC);            
   	  		   vEEPRequired	= FALSE;
   	  		   vEEPTransferInProgress = FALSE;
   	  		   vEEPResend = 0;
   	  		   vEEPAvailable = FALSE;
   	  		}
   		}	
    }

	// Valid vEEPROM reported from Rx
   	if((Msg->Device & 0x0002) == 0) 
   	{
   	  	vEEPRequired	= FALSE;
   	  	vEEPTransferInProgress = FALSE;
   	  	vEEPResend = 0;
   	  	vEEPBlockBitMap = 0;
   	}
}                                                 
                                      
                                           
